#!/bin/bash
# PHP에서 curl-impersonate 사용 설정

INSTALL_DIR="$1"
if [[ -z "$INSTALL_DIR" ]]; then
    echo "Usage: $0 /path/to/curl-impersonate"
    exit 1
fi

echo "Setting up PHP to use curl-impersonate..."

# 라이브러리 복사
sudo cp -P "$INSTALL_DIR/lib/libcurl-impersonate-chrome.so"* /usr/local/lib/
sudo ldconfig

cat <<'ENVEOF'

=== PHP에서 curl-impersonate 사용하기 ===

방법 1: LD_PRELOAD 사용 (전역)
    export LD_PRELOAD=/usr/local/lib/libcurl-impersonate-chrome.so
    export CURL_IMPERSONATE=chrome116
    php your-script.php

방법 2: PHP-FPM 설정
    /etc/php/8.x/fpm/pool.d/www.conf에 추가:
    env[LD_PRELOAD] = /usr/local/lib/libcurl-impersonate-chrome.so
    env[CURL_IMPERSONATE] = chrome116

방법 3: Apache 설정
    /etc/apache2/envvars에 추가:
    export LD_PRELOAD=/usr/local/lib/libcurl-impersonate-chrome.so
    export CURL_IMPERSONATE=chrome116

PHP 코드 예시:
<?php
$ch = curl_init('https://www.example.com');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);
?>

ENVEOF

echo "Setup complete!"
